let text_StatusOut = document.getElementById("statusOut");

let buttonConnectDevice = document.getElementById("connect-device");
let inputHwVersion = document.getElementById("hwVersionShow");
let inputSwVersion = document.getElementById("swVersionShow");

let buttonSelectFwFile = document.getElementById("select-fw-file");
let inputAutoReset = document.getElementById("auto-reset");
let buttonDownloadFw = document.getElementById("downloadFw");
let buttonAutoTest = document.getElementById("auto_test");
let processDownloadFw = document.getElementById("downloadFw-process");

let buttonSelectDataFile = document.getElementById("select-data-file");
let buttonDownloadData = document.getElementById("downloadData");
let processDownloadData = document.getElementById("downloadData-process");

var hidDevice = null;
let selectFwFile = null;
let selectDataFile = null;
var taskType = 0;
var simudevTaskPosTx = 0;
var simudevTaskPosRx = 0;

var app_const_character_xxx;
var app_hardware_version;
var app_firmware_version;

function uiStatusOut(str) {
  text_StatusOut.value = str;
  text_StatusOut.style.background = '';
}

function disconnectDevice() {
  hidDevice = null;
  buttonDownloadFw.disabled = true;
  buttonAutoTest.disabled = true;
  buttonDownloadData.disabled = true;
}

(async () => {
  buttonConnectDevice.addEventListener("click", async () => {
    if (hidDevice) {
      disconnectDevice(hidDevice);
    } else {
      let devices;
      try {
        devices = await navigator.hid.requestDevice({
          filters: [
            {
              vendorId: 0x2B81,
              productId: 0x0101,
            }
          ],
        });

        if (devices.length > 0) {
          hidDevice = devices[0];
          console.log(hidDevice);

          if (!hidDevice.opened) {
            await hidDevice.open();
          }

          hidDevice.oninputreport = inputReportHandler;

          buttonConnectDevice.textContent = "Disconnect";
          
          // get app info
          simudevTaskGetAppInfo(hidDevice, 0);
        }
      } catch (e) {
        console.log("Connection error: " + e);
      }
    }
  });

  buttonSelectFwFile.addEventListener("change", async () => {
    selectFwFile = null;
    buttonDownloadFw.disabled = true;

    if (buttonSelectFwFile.files.length > 0) {
      let file = buttonSelectFwFile.files[0];
      let reader = new FileReader();
      reader.onload = function () {
        selectFwFile = reader.result.slice(0);
        if (hidDevice != null) {
          buttonDownloadFw.disabled = false;
        }
      };
      reader.readAsArrayBuffer(file);
    }
  });

  buttonDownloadFw.addEventListener("click", async () => {
    simudevTaskFirmwareWrite(hidDevice, selectFwFile);
  });
  
  buttonAutoTest.addEventListener("click", async () => {
    simudevTaskAutoTest(hidDevice);
  });

  buttonSelectDataFile.addEventListener("change", async () => {
    selectDataFile = null;
    buttonDownloadData.disabled = true;

    if (buttonSelectDataFile.files.length > 0) {
      let file = buttonSelectDataFile.files[0];
      let reader = new FileReader();
      reader.onload = function () {
        selectDataFile = reader.result.slice(0);
        if (hidDevice != null) {
          buttonDownloadData.disabled = false;
        }
      };
      reader.readAsArrayBuffer(file);
    }
  });

  buttonDownloadData.addEventListener("click", async () => {
    simudevTaskDataWrite(hidDevice, selectDataFile);
  });
})();

function inputReportHandler(event) {
  const { data, device, reportId } = event;

  if (data.byteLength == 63) {
    const respCmd = data.getUint8(0);
    console.log('inputReportHandler: ' + respCmd);
    if (respCmd == CMD_PRIVATE_FIRMWARE_INFO_GET) {
      taskType = 0;
      const respAppSelect = data.getUint8(1);
      const const_character_xxx = data.getUint32(1 + 1, true);
      const info_valid_length = data.getUint32(1 + 1 + 4, true);
      const hardware_version = data.getUint32(1 + 1 + 4 + 4, true);
      const firmware_version = data.getUint32(1 + 1 + 4 + 4 + 4, true);
      if (respAppSelect == 0) {
        console.log("Cur App.const_character: " + const_character_xxx.toString(16).padStart(8, 0));
        console.log("Cur App.info_valid_length: " + info_valid_length.toString(16));
        console.log("Cur App.hardware_version: " + hardware_version.toString(16).padStart(8, 0));
        inputHwVersion.value = hardware_version.toString(16).padStart(8, 0);
        console.log("Cur App.firmware_version: " + firmware_version.toString(16).padStart(8, 0));
        inputSwVersion.value = firmware_version.toString(16).padStart(8, 0);
        uiStatusOut("Current Firmware Code: " + firmware_version.toString(16).padStart(8, 0));
        app_const_character_xxx = const_character_xxx;
        app_hardware_version = hardware_version;
        app_firmware_version = firmware_version;

        if (selectFwFile != null) {
          buttonDownloadFw.disabled = false;
        }
        if (selectDataFile != null) {
          buttonDownloadData.disabled = false;
        }
        buttonAutoTest.disabled = false;
      } else {
        console.log("New App.const_character: " + const_character_xxx.toString(16).padStart(8, 0));
        console.log("New App.info_valid_length: " + info_valid_length.toString(16));
        console.log("New App.hardware_version: " + hardware_version.toString(16).padStart(8, 0));
        console.log("New App.firmware_version: " + firmware_version.toString(16).padStart(8, 0));
        
        if ((app_const_character_xxx == const_character_xxx) && (app_hardware_version == hardware_version)) {
          uiStatusOut("Update Finish! New Firmware Code: " + firmware_version.toString(16).padStart(8, 0));
          text_StatusOut.style.background = 'rgba(0, 128, 0, 0.5)';
          if (inputAutoReset.checked == true) {
            simudevTaskReset(device);
          }
        } else {
          uiStatusOut("Update Fail! Expect " + app_const_character_xxx.toString(16).padStart(8, 0) + "." + app_hardware_version.toString(16).padStart(8, 0) + ". Actual " + const_character_xxx.toString(16).padStart(8, 0) + "." + hardware_version.toString(16).padStart(8, 0));
          text_StatusOut.style.background = 'rgba(128, 0, 0, 0.5)';
        }
      }
    } else if (respCmd == CMD_PRIVATE_FIRMWARE_WRITE_42) {
      taskType = 0;
      var write_pos = data.getUint32(1, true);
      const write_length = 42;

      console.log('  Flash Write Done: ' + simudevTaskPosRx + '@' + selectFwFile.byteLength + ", Result: " + write_pos);

      simudevTaskPosRx += write_length;
      if (write_pos != 0xffffffff) {
        uiStatusOut('Flash Write : ' + simudevTaskPosRx + ' bytes has been written @ ' + write_pos);
      } else {
        uiStatusOut('Flash Write : ' + simudevTaskPosRx + ' bytes has been skiped');
      }
      simudevTaskPosTx += simudevTryFlashWrite(device, selectFwFile, simudevTaskPosTx, simudevTaskPosRx);
    } else if (respCmd == CMD_PRIVATE_FIRMWARE_WRITE_4) {
      taskType = 0;
      var write_pos = data.getUint32(1, true);
      const write_length = 4;

      console.log('  Flash Write Done: ' + simudevTaskPosRx + '@' + selectFwFile.byteLength + ", Result: " + write_pos);

      simudevTaskPosRx += write_length;
      if (write_pos != 0xffffffff) {
        uiStatusOut('Flash Write : ' + simudevTaskPosRx + ' bytes has been written @ ' + write_pos);
      } else {
        uiStatusOut('Flash Write : ' + simudevTaskPosRx + ' bytes has been skiped');
      }
      simudevTaskPosTx += simudevTryFlashWrite(device, selectFwFile, simudevTaskPosTx, simudevTaskPosRx);
    } else if (respCmd == CMD_PRIVATE_RESET) {
      taskType = 0;
      disconnectDevice();
    } else if (respCmd == CMD_PRIVATE_ENTER_AUTO_TEST) {
      taskType = 0;
      disconnectDevice();
    } else if (respCmd == CMD_PRIVATE_DATA_GETVERSION) {
      taskType = 0;

      var decoder = new TextDecoder("utf-8");
      console.log('Boot Version: ' + decoder.decode(data.buffer.slice(1, 9)));
      var decoder = new TextDecoder("utf-8");
      console.log('App Version: ' + decoder.decode(data.buffer.slice(1 + 8, 9 + 8)));
      var decoder = new TextDecoder("utf-8");
      console.log('Data Version: ' + decoder.decode(data.buffer.slice(1 + 8 + 8, 9 + 8 + 8)));

      uiStatusOut('Cur Data Version: ' + decoder.decode(data.buffer.slice(1 + 8 + 8, 9 + 8 + 8)));

      // goon
      simudevTaskPosTx += simudevTryDataWrite(device, selectDataFile, simudevTaskPosTx, simudevTaskPosRx);
    } else if (respCmd == CMD_PRIVATE_DATA_EXIT_AND_VERSION) {
      taskType = 0;
      
      var decoder = new TextDecoder("utf-8");
      console.log('Boot Version: ' + decoder.decode(data.buffer.slice(1, 9)));
      var decoder = new TextDecoder("utf-8");
      console.log('App Version: ' + decoder.decode(data.buffer.slice(1 + 8, 9 + 8)));
      var decoder = new TextDecoder("utf-8");
      console.log('Data Version: ' + decoder.decode(data.buffer.slice(1 + 8 + 8, 9 + 8 + 8)));

      uiStatusOut('New Data Version: ' + decoder.decode(data.buffer.slice(1 + 8 + 8, 9 + 8 + 8)));

    } else if (respCmd == CMD_PRIVATE_DATA_WRITE_42) {
      taskType = 0;
      var write_pos = data.getUint32(1, true);
      const write_length = 42;

      console.log('  Data Write Done: ' + simudevTaskPosRx + '@' + selectDataFile.byteLength + ", Result: " + write_pos);

      simudevTaskPosRx += write_length;
      if (write_pos != 0xffffffff) {
        uiStatusOut('Data Write : ' + simudevTaskPosRx + ' bytes has been written @ ' + write_pos);
      } else {
        uiStatusOut('Data Write : ' + simudevTaskPosRx + ' bytes has been skiped');
      }
      simudevTaskPosTx += simudevTryDataWrite(device, selectDataFile, simudevTaskPosTx, simudevTaskPosRx);
    } else if (respCmd == CMD_PRIVATE_DATA_WRITE_36) {
      taskType = 0;
      var write_pos = data.getUint32(1, true);
      const write_length = 36;

      console.log('  Data Write Done: ' + simudevTaskPosRx + '@' + selectDataFile.byteLength + ", Result: " + write_pos);

      simudevTaskPosRx += write_length;
      if ((write_pos == (write_pos % 0x120))) {
        simudevTaskDataGetVersion(device);
      } else {
        if (write_pos != 0xffffffff) {
          uiStatusOut('Data Write : ' + simudevTaskPosRx + ' bytes has been written @ ' + write_pos);
        } else {
          uiStatusOut('Data Write : ' + simudevTaskPosRx + ' bytes has been skiped');
        }
        simudevTaskPosTx += simudevTryDataWrite(device, selectDataFile, simudevTaskPosTx, simudevTaskPosRx);
      }
    }
  }
}

function simudevTaskReset(device) {
  if (taskType) {
    return;
  }

  console.log('simudevTaskReset');
  var array = dev_cmd_private_reset();
  taskType = array[0];

  device.sendReport(2, array);
}

function simudevTaskAutoTest(device) {
  if (taskType) {
    return;
  }

  console.log('simudevTaskAutoTest');
  var array = dev_cmd_private_enter_auto_test();
  taskType = array[0];

  device.sendReport(2, array);
}

function simudevTaskGetAppInfo(device, appSelect) {
  if (taskType) {
    return;
  }

  console.log('simudevTaskGetAppInfo');

  var array = dev_cmd_private_firmware_info_get(appSelect);
  taskType = array[0];
  device.sendReport(2, array);
}

function simudevTryFlashWrite(device, fileData, posTx, posRx) {
  if (fileData.byteLength <= posRx) {
    uiStatusOut('Flash Write Finish.' + posRx + ' bytes has been written.');

    processDownloadFw.value = 100;

    // get new app info
    simudevTaskGetAppInfo(device, 1);
  } else {
    processDownloadFw.value = Math.ceil(posRx * 100 / fileData.byteLength);

    if (fileData.byteLength > posTx) {
      var data_len = fileData.byteLength - posTx;

      if (((data_len % 256) == 0) || ((data_len % 256) >= 42)) {
        taskType = CMD_PRIVATE_FIRMWARE_WRITE_42;

        var array = dev_cmd_private_firmware_write_42(0, fileData, posTx, 42);
        console.log('Write_42: Pos ' + posTx + ', Len ' + array.byteLength);
        device.sendReport(2, array);
        return 42;
      } else {
        taskType = CMD_PRIVATE_FIRMWARE_WRITE_4;

        var array = dev_cmd_private_firmware_write_4(0, fileData, posTx, 4);
        console.log('Write_04: Pos ' + posTx);
        device.sendReport(2, array);
        return 4;
      }
    }
  }
  return 0;
}

function simudevTaskFirmwareWrite(device, fileData) {
  if (taskType) {
    return;
  }

  console.log('simudevTaskFirmwareWrite');
  simudevTaskPosTx = 0;
  simudevTaskPosRx = 0;

  simudevTaskPosTx += simudevTryFlashWrite(device, fileData, simudevTaskPosTx, simudevTaskPosRx);
}

function simudevTaskDataGetVersion(device) {
  if (taskType) {
    return;
  }

  console.log('simudevTaskDataGetVersion');
  var array = dev_cmd_private_data_getversion();
  taskType = array[0];

  device.sendReport(2, array);
}

function simudevTaskDataExitAndVersion(device) {
  if (taskType) {
    return;
  }

  console.log('simudevTaskDataExitAndVersion');
  var array = dev_cmd_private_data_exit_and_version();
  taskType = array[0];

  device.sendReport(2, array);
}

function simudevTryDataWrite(device, fileData, posTx, posRx) {
  if (fileData.byteLength <= posRx) {
    uiStatusOut('Data Write Finish.' + posRx + ' bytes has been written.');

    processDownloadData.value = 100;

    // EXIT_AND_VERSION
    simudevTaskDataExitAndVersion(device);
  } else {
    processDownloadData.value = Math.ceil(posRx * 100 / fileData.byteLength);

    if (fileData.byteLength > posTx) {
      var data_len = fileData.byteLength - posTx;

      if (((data_len % 0x120) == 0) || ((data_len % 0x120) >= 42)) {
        taskType = CMD_PRIVATE_DATA_WRITE_42;

        var array = dev_cmd_private_data_write_42(fileData, posTx, 42);
        console.log('Write_42: Pos ' + posTx + ', Len ' + array.byteLength);
        device.sendReport(2, array);
        return 42;
      } else {
        taskType = CMD_PRIVATE_DATA_WRITE_36;

        var array = dev_cmd_private_data_write_36(fileData, posTx, 36);
        console.log('Write_36: Pos ' + posTx);
        device.sendReport(2, array);
        return 36;
      }
    }
  }
  return 0;
}

function simudevTaskDataWrite(device, fileData) {
  if (taskType) {
    return;
  }

  console.log('simudevTaskDataWrite');
  simudevTaskPosTx = 0;
  simudevTaskPosRx = 0;

  simudevTaskPosTx += simudevTryDataWrite(device, fileData, simudevTaskPosTx, simudevTaskPosRx);
}